//---------------------------------------------------------------------------
#ifndef ImporterH
#define ImporterH
//---------------------------------------------------------------------------

#include "3dsftk.h"
#include "math/matrix.h"

class Import3DS
   {
   protected:

      file3ds * file;
      database3ds *db;
      namelist3ds *meshlist;

   public:

      bool PrintError(void);

      bool BeginImport(char * filename);
      void EndImport(void);

      int GetMeshCount(void);
      int GetVertexCount(int mesh_index);
      int GetFaceCount(int mesh_index);

      void GetVertex(int mesh_index, int vertex_index, float * x = 0,float * y = 0,float * z = 0);
      void GetTexcoords(int mesh_index, int vertex_index, float * u = 0,float * v = 0);
      void GetFace(int mesh_index, int face_index, int * v1 = 0, int * v2 = 0, int * v3 = 0);

      float GetMatrix(int mesh_index, int i, int j);

   };

#endif
